<?php
$site = ['name' => 'Promi Blick'];
$domain = 'promi-blick.net';
$article_path = 'lablabi-tunisias-heartwarming-chickpea-soup';
$full_path = "https://$domain/$article_path";
$author = 'Tim Schneider';
$title = 'Lablabi: Tunisia’s Heartwarming Chickpea Soup';
$description = 'When it comes to comfort food from North Africa, few dishes rival the humble yet hearty Lablabi. This traditional Tunisian soup, made primarily from chickpeas and flavored with garlic, cumin, and a hint of spice, is a staple for locals and an emerging favorite among global food lovers. Its simplicity, versatility, and soul-satisfying flavors make it a dish worth exploring.';
$image_path = '../assets/images/sa2.jpeg';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?= htmlspecialchars($title); ?></title>
    <meta name="description" content="<?= htmlspecialchars($description); ?>">

    <meta property="og:title" content="<?= htmlspecialchars($title); ?>">
    <meta property="og:type" content="article">
    <meta property="og:url" content="<?= $full_path; ?>">
    <meta property="og:image" content="<?= $image_path; ?>">
    <meta property="og:description" content="<?= htmlspecialchars($description); ?>">
    <meta property="og:site_name" content="<?= htmlspecialchars($site['name']); ?>">
    <meta name="author" content="<?= htmlspecialchars($author); ?>">

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Playfair+Display:wght@600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: #f1f5f9;
            color: #0f172a;
        }

        .article-wrapper {
            background: #ffffff;
            border-radius: 1.25rem;
            border: 1px solid #e2e8f0;
        }

        .article-content {
            font-size: 1.05rem;
            line-height: 1.85;
            color: #1f2937;
        }

        .article-content p {
            margin-bottom: 1.6rem;
        }

        .article-content h2 {
            font-family: 'Playfair Display', serif;
            font-size: 1.6rem;
            font-weight: 600;
            margin-top: 3.5rem;
            margin-bottom: 1.25rem;
            padding-left: 0.75rem;
            border-left: 4px solid #ca8a04;
        }

        .article-content ul {
            padding-left: 1.25rem;
        }

        .article-content li {
            margin-bottom: 0.75rem;
        }

        .lead {
            font-size: 1.15rem;
            color: #475569;
            font-weight: 500;
        }

        .tag {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            padding: 0.4rem 0.9rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
        }
    </style>
</head>

<body>

    <?php include('../header.php'); ?>

    <main class="max-w-4xl mx-auto px-5 sm:px-6 py-16">

        <!-- ARTICLE CARD -->
        <article class="article-wrapper p-8 sm:p-12">

            <!-- CATEGORY -->
            <span class="inline-block mb-4 text-xs font-semibold tracking-wide uppercase text-amber-700">
                Pet & Lifestyle
            </span>

            <!-- TITLE -->
            <h1 class="text-4xl sm:text-5xl font-bold leading-tight tracking-tight mb-6"
                style="font-family:'Playfair Display',serif">
                <?= htmlspecialchars($title); ?>
            </h1>

            <!-- META -->
            <div class="flex items-center gap-3 text-sm text-slate-500 mb-10">
                <span class="font-medium text-slate-800"><?= htmlspecialchars($author); ?></span>
                <span>•</span>
                <time><?= date('F j, Y'); ?></time>
            </div>

            <!-- FEATURE IMAGE -->
            <img src="<?= $image_path; ?>"
                alt="<?= htmlspecialchars($title); ?>"
                class="w-full aspect-[16/9] object-cover rounded-xl mb-14">

            <!-- CONTENT -->
            <div class="article-content">
                <?php include('content.php'); ?>
            </div>

            <!-- TAGS -->
            <div class="mt-12 flex gap-3">
                <span class="tag">Food</span>
                <span class="tag">Lifestyle</span>
                <span class="tag">Trends</span>
            </div>

        </article>
    </main>

    <?php include('../footer.php'); ?>

</body>

</html>